IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_Caja_Transf_Alias_Cont]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Caja_Transf_Alias_Cont 
END
GO

CREATE FUNCTION dbo.CF_Caja_Transf_Alias_Cont   (@Id_Periodo_Caja INT, @Id_Tipo_Val CHAR(3),@Id_Moneda CHAR(3))
RETURNS INT	
AS
BEGIN

DECLARE @Retorno 	SMALLINT
	,@Id_Caja INT
	,@Id_Concepto INT
	
SET @Id_Caja = ISNULL(
				(SELECT Id_Caja  FROM Cajas_Periodos WHERE Id_Periodo_Caja = @Id_Periodo_Caja)
				,0)
/* Tabla de cuentas de la caja*/
SET @Retorno = ISNULL(
				(SELECT Id_Alias_Cta_Cont FROM Cajas_Ctas_Cont 
				    WHERE Id_Caja = @Id_Caja 
					  AND Id_Tipo_Val = @Id_Tipo_Val
					  AND Id_Moneda = @Id_Moneda )
				,0)

/* Cuenta de la caja*/
IF @Retorno = 0 AND @Id_Tipo_Val = 'EFE'
BEGIN
	SET @Retorno = ISNULL(
					(SELECT Id_Cta_Contable FROM Cajas 
						WHERE Id_Caja = @Id_Caja)
					,0)
END

/* Cuenta de los valores*/
IF @Retorno = 0
BEGIN
	SET @Retorno = ISNULL(
					(SELECT Id_Alias_Cta_Cont  FROM Valores_Tipos
						WHERE Id_Tipo_Val = @Id_Tipo_Val)
					,0)

END

/* Cuenta de los valores*/
IF @Retorno = 0
BEGIN
	SET @Id_Concepto = ISNULL(
					dbo.CF_xParam('Trans_Concepto')
					,0)
	SET @Retorno = ISNULL(
					(SELECT Id_Cta_Contable FROM Conceptos
						WHERE Id_Concepto = @Id_Concepto)
					,0)

END

RETURN ISNULL(@Retorno,0);

END
       
  